package cn.com.duiba.supplier.channel.service.api.remoteservice.conf;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

import java.util.Map;

/**
 * 微信支付商户配置
 * @author lizhi
 * @date 2023/8/19 17:50
 */
@AdvancedFeignClient
public interface RemoteWxpayMchConfService {

    /**
     * 查询所有的商户名称
     * @return key：mchId，value：商户名称
     */
    Map<String, String> selectAllMchNameMap();

    /**
     * 查询所有的商户名称，根据商户类型
     * @return key：mchId，value：商户名称
     */
    Map<String, String> selectAllMchNameMapByMchType(Integer mchType);
}
