package cn.com.duiba.supplier.channel.service.api.dto.request;

import cn.com.duiba.supplier.channel.service.api.enums.order.BizTypeEnum;
import cn.com.duiba.supplier.channel.service.api.enums.order.ChannelTypeEnum;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import java.io.Serializable;

/**
 * @author lizhi
 * @date 2023/4/10 4:08 PM
 */
@Data
public class CloseReq implements Serializable {
    
    private static final long serialVersionUID = 8594994864388933701L;

    /**
     * 渠道类型
     * {@link ChannelTypeEnum}
     */
    @NotNull(message = "channelType不能为空")
    private Integer channelType;

    /**
     * 业务类型
     * {@link BizTypeEnum}
     */
    @NotNull(message = "bizType不能为空")
    private Integer bizType;

    /**
     * 业务方唯一单号
     * 注意：实际长度不能大于渠道长度-6，比如渠道最大长度为32，则bizNo最大长度为26
     * （实际生成商户单号默认规则：业务类型+分隔符+bizNo+分隔符+重试次数，渠道实现类可重写规则）
     */
    @NotBlank(message = "bizNo不能为空")
    @Size(max = 64, message = "bizNo不能超过64")
    private String bizNo;

    /**
     * 关单原因
     * 强制关闭订单时必填
     */
    @Size(max = 255, message = "closeReason不能超过255")
    private String closeReason;

    /**
     * 强制关闭订单：注意设置为true有超发风险
     * false-不确定状态会关闭失败
     * true-未成功的订单，都可以关闭掉，但是有可能导致超发（比如我们这边处理中，供应商后来成功了）
     */
    private boolean forceClose;
}
