package cn.com.duiba.supplier.channel.service.api.dto.response.telaidian;

import lombok.Data;

import java.io.Serializable;

/**
 * 特来电卡劵直充Resp.
 *
 * @author fmk
 * @since 2024/1/15
 */
@Data
public class TeLaiDianCouponZcResp implements Serializable {

    private static final long serialVersionUID = 7022897259613176233L;

    /**
     * 订单内码
     */
    private String orderId;

    /**
     * 外部订单号
     */
    private String outOrderId;

    /**
     * 订单状态<br>
     * 1 - 初始
     * 2 - 支付成功
     * 3 - 发券成功
     *
     * @see cn.com.duiba.supplier.channel.service.api.enums.channel.TeLaiDianOrderStatusEnum
     */
    private String orderStatus;

    /**
     * 产品内码
     */
    private String productId;

    /**
     * 卡劵编号
     */
    private String ticketCode;

    /**
     * 卡劵状态<br>
     * 0 - 未激活
     * 1 - 已生效
     * 2 - 已使用
     * 3 - 已用完
     * 4 - 已作废
     *
     * @see cn.com.duiba.supplier.channel.service.api.enums.channel.TeLaiDianTicketStatusEnum
     */
    private String ticketStatus;

    /**
     * 卡劵面值
     */
    private String ticketValue;

    /**
     * 剩余面值
     */
    private String ticketAvailableValue;

    /**
     * 有效开始时间
     */
    private String effDate;

    /**
     * 有效结束时间
     */
    private String expiryDate;

}
