package cn.com.duiba.supplier.channel.service.api.enums.channel;

import cn.com.duiba.boot.exception.BizException;
import lombok.Getter;
import lombok.RequiredArgsConstructor;

import java.util.Objects;

/**
 * JDCodeEnum
 *
 * @author fmk
 * @since 2024/3/18
 */
@Getter
@RequiredArgsConstructor
public enum JdCodeEnum {

    SUCCESS("0", "成功"),
    INVALID_VERIFICATION_CODE("104", "验证码已过期或不正确"),
    PARAM_INVALIDE("400", "入参不正确"),
    USER_INVALID("401", "验证用户有效性失败"),
    REPEAT_THIRDORDER("402", "第三方订单号重复"),
    UNAUTHORIZED("403", "token验证未通过"),
    ORDER_NOT_EXIST("404", "订单不存在"),
    BALANCE_NOT_ENOUGH("405", "余额不足"),
    NOT_HOTEL_ORDER("406", "该订单不是酒店订单"),
    ORDER_IS_PAYING("407", "该订单正在支付中"),
    INVOKE_EXCE("500", "调用接口异常"),
    INVOKE_ERRORMSG("501", "调用接口返回错误信息"),
    CONNECTION_ERROR("502", "调用下游接口网络连接错误"),
    ORDER_FAILED("503", "下单失败"),
    NOT_GET_BALANCE("504", "未查询到余额"),
    AIR_CHECK("505", "下单成功，但是价格校验失败"),
    GIFT_ORDER("506", "礼品卡下单接口返回失败"),
    PAY_OUT_TIME("601", "超过支付有效时间，不能支付"),
    PRICE_CHECK("602", "价格校验失败，不能支付"),
    CONN_EXCE("900", "网络异常");

    private final String code;
    private final String description;

    public static JdCodeEnum getByCode(String code) throws BizException {
        for (JdCodeEnum codeEnum : values()) {
            if (Objects.equals(codeEnum.getCode(), code)) {
                return codeEnum;
            }
        }
        throw new BizException("状态码错误,code=" + code);
    }

}
