package cn.com.duiba.supplier.channel.service.api.enums.channel;


import lombok.AllArgsConstructor;
import lombok.Getter;

@Getter
@AllArgsConstructor
public enum MeiTuanCouponTypeEnum {
    PAYMENT_COUPON(1, "支付券"),
    PAYMENT_REDUCTION(2, "支减"),
    FIRST_BINDING(3, "首绑"),
    MULTIPLE_SWIPES(4, "多刷"),
    ;

    /**
     * 状态码
     */
    private final Integer code;
    /**
     * 描述
     */
    private final String desc;

    //根据状态码获取枚举
    public static MeiTuanCouponTypeEnum getByCode(Integer code) {
        for (MeiTuanCouponTypeEnum statusEnum : values()) {
            if (statusEnum.code.equals(code)) {
                return statusEnum;
            }
        }
        return null;
    }
}
