package cn.com.duiba.supplier.channel.service.api.enums.dingtalk;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * @author xuzhigang
 * @date 2024/10/20 22:10
 **/
@Getter
@AllArgsConstructor
public enum DingTalkCallbackEventEnum {

    /**
     * <a href=https://open.dingtalk.com/document/orgapp/event-bpms-task-change>审批任务开始、结束、取消</a>
     */
    BPMS_TASK_CHANGE("bpms_task_change", "审批任务开始、结束、转交"),

    /**
     * <a href=https://open.dingtalk.com/document/orgapp/event-bpms-instance-change>审批实例开始、结束。</a>
     */
    BPMS_INSTANCE_CHANGE("bpms_instance_change", "审批实例开始、结束。"),

    /**
     * <a href=https://open.dingtalk.com/document/orgapp/event-v3user-add-org#>企业增加员工事件</a>
     */
    USER_ADD_ORG("user_add_org", "企业增加员工事件"),

    /**
     * <a href=https://open.dingtalk.com/document/orgapp/event-v3user-leave-org#>企业员工离职事件</a>
     */
    USER_LEAVE_ORG("user_leave_org", "企业员工离职事件"),

    /**
     * <a href=https://open.dingtalk.com/document/orgapp/event-org-dept-create#>通讯录企业部门创建</a>
     */
    ORG_DEPT_CREATE("org_dept_create", "通讯录企业部门创建"),


    /**
     * <a href=https://open.dingtalk.com/document/orgapp/event-v3org-dept-remove#>通讯录企业部门删除</a>
     */
    ORG_DEPT_REMOVE("org_dept_remove", "通讯录企业部门删除"),

    /**
     * <a href=https://open.dingtalk.com/document/orgapp/event-org-dept-modify#>通讯录企业部门修改</a>
     */
    ORG_DEPT_MODIFY("org_dept_modify", "通讯录企业部门修改"),

    ;
    private final String eventType;

    private final String desc;

    public static DingTalkCallbackEventEnum getByEventType(String eventType) {
        for (DingTalkCallbackEventEnum eventEnum : DingTalkCallbackEventEnum.values()) {
            if (eventEnum.getEventType().equals(eventType)) {
                return eventEnum;
            }
        }
        return null;
    }
}
