package cn.com.duiba.supplier.channel.service.api.enums.express;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 物流类型
 *
 * @author wangguanhua
 */
@Getter
@AllArgsConstructor
public enum ExpressMqCallbackTypeEnum {

    SUBSCRIBE_RESULT(1, "物流订阅结果"),
    EXPRESS_STATUS_RESULT(2, "物流状态结果"),
    ;

    private static final Map<Integer, ExpressMqCallbackTypeEnum> ENUM_MAP = Collections.unmodifiableMap(Arrays.stream(values()).collect(Collectors.toMap(ExpressMqCallbackTypeEnum::getType, Function.identity(), (v1, v2) -> v2)));

    /**
     * 类型
     */
    private final Integer type;

    /**
     * 描述
     */
    private final String desc;

    public static ExpressMqCallbackTypeEnum getByType(Integer type) {
        if (type == null) {
            return null;
        }
        return ENUM_MAP.get(type);
    }

}
