package cn.com.duiba.supplier.channel.service.api.dto.response.wx.favor;

import lombok.Data;

import java.io.Serializable;

/**
 * 微信立减金发放结果
 * @author lizhi
 * @date 2023/5/17 5:18 PM
 */
@Data
public class WxFavorUserCouponsResp implements Serializable {
    
    private static final long serialVersionUID = -7930115594396446814L;

    /**
     * 代金券id	 
     */
    private String couponId;

    /**
     * 可用结束时间(仅当入参为需要查询券详情时有值)							 
     * 说明：可用结束时间，遵循rfc3339标准格式，格式为yyyy-MM-DDTHH:mm:ss+TIMEZONE，yyyy-MM-DD表示年月日，T出现在字符串中，表示time元素的开头，HH:mm:ss表示时分秒，TIMEZONE表示时区（+08:00表示东八区时间，领先UTC 8小时，即北京时间）。例如：2015-05-20T13:29:35+08:00表示，北京时间2015年5月20日 13点29分35秒。
     * 必填，string(32)
     */
    private String availableEndTime;

    /**
     * 代金券状态
     * 说明：代金券状态： SENDED：可用, USED：已实扣, EXPIRED：已过期
     * 必填，string(16)
     */
    private String status;

    /**
     * 微信返回的业务参数（手动模拟微信立减金回调过期时使用）
     */
    private String queryResult;
}
