package cn.com.duiba.supplier.channel.service.api.dto.dingtalk;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

import lombok.Data;

/**
 * 钉钉审批操作记录表
 * @author mybatis generator 
 * @date 2024-10-19
 */
@Data
public class DingTalkApprovalRecordDto implements Serializable {
     
    private static final long serialVersionUID = 17293027638906146L;

    /**
     * 任务节点ID
     */
    public String activityId;

    /**
     * 评论附件列表
     */
    public List<DingTalkApprovalRecordAttachmentDto> attachments;

    public List<String> ccUserIds;

    /**
     * 抄送人userIds列表。
     */
    public String date;

    /**
     * 单个图片链接
     */
    public List<String> images;

    /**
     * 评论内容。
     */
    public String remark;

    /**
     * 操作结果。
     * AGREE：同意
     * REFUSE：拒绝
     * NONE：未处理
     */
    public String result;

    /**
     * 任务节点名称
     */
    public String showName;

    /**
     * 操作类型。
     * EXECUTE_TASK_NORMAL：正常执行任务
     * EXECUTE_TASK_AGENT：代理人执行任务
     * APPEND_TASK_BEFORE：前加签任务
     * APPEND_TASK_AFTER：后加签任务
     * REDIRECT_TASK：转交任务
     * START_PROCESS_INSTANCE：发起流程实例
     * TERMINATE_PROCESS_INSTANCE：终止(撤销)流程实例
     * FINISH_PROCESS_INSTANCE：结束流程实例
     * ADD_REMARK：添加评论
     * REDIRECT_PROCESS：审批退回
     * PROCESS_CC：抄送
     */
    public String type;

    /**
     * 操作人userId。
     */
    public String userId;
}