package cn.com.duiba.supplier.channel.service.api.remoteservice.dingtalk;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.supplier.channel.service.api.dto.dingtalk.DingTalkAppConfDto;

/**
 * @author xuzhigang
 * @date 2024/10/17 10:57
 **/
@AdvancedFeignClient
public interface RemoteDingTalkAppConfService {

    /**
     * 根据主键id查询钉钉配置
     * @param id 主键id
     * @return 钉钉配置
     */
    DingTalkAppConfDto selectById(Long id);

    /**
     * 根据主键id查询钉钉配置 本地缓存
     * @param id 主键id
     * @return 钉钉app配置
     */
    DingTalkAppConfDto selectByIdLocal(Long id);

    /**
     * 根据appKey查询钉钉配置
     * @param appKey 应用key
     * @return 钉钉配置
     */
    DingTalkAppConfDto selectByAppKey(String appKey);

    /**
     * 根据appKey查询钉钉配置 本地缓存
     * @param appKey 应用key
     * @return 钉钉app配置
     */
    DingTalkAppConfDto selectByAppKeyLocal(String appKey);
}
