package cn.com.duiba.supplier.channel.service.api.dto.dingtalk;

import java.io.Serializable;
import java.util.Date;
import lombok.Data;

/**
 * 钉钉审批任务表
 * @author mybatis generator 
 * @date 2024-10-19
 */
@Data
public class DingTalkApprovalTaskDto implements Serializable {
     
    private static final long serialVersionUID = 17293027638956886L;

    /**
     * tb_ding_talk_approval_process.id
     */
    private Long processId;

    /**
     * 审批实例id
     */
    private String instanceId;

    /**
     * 每个企业拥有唯一的CorpId
     */
    private String corpId;

    /**
     * 审批任务id
     */
    private Long taskId;

    /**
     * 任务节点ID
     */
    private String activityId;

    /**
     * 任务状态 NEW-未启动 RUNNING-处理中 PAUSED-暂停 CANCELED-取消 COMPLETED-完成 TERMINATED-终止
     * @see cn.com.duiba.supplier.channel.service.api.enums.dingtalk.BpmsInstanceTaskStatusEnum
     */
    private String status;

    /**
     * 任务结果 AGREE-同意 REFUSE-拒绝 REDIRECTED-转交
     * @see cn.com.duiba.supplier.channel.service.api.enums.dingtalk.BpmsInstanceTaskResultEnum
     */
    private String result;

    /**
     * 任务处理人
     */
    private String userId;

    /**
     * 审批结束时间
     */
    private String finishTime;

    /**
     * 审批创建时间
     */
    private String createTime;

    /**
     * 移动端任务URL。
     */
    public String mobileUrl;

    /**
     * PC端任务URL。
     */
    public String pcUrl;

}