package cn.com.duiba.supplier.channel.service.api.dto.request.alipay.transfer;

import java.io.Serializable;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;

import cn.com.duiba.supplier.channel.service.api.enums.alipay.AlipayTransferBizSceneEnum;
import cn.com.duiba.supplier.channel.service.api.enums.alipay.AlipayTransferProductCodeEnum;
import lombok.Data;

/**
 * 支付宝B2C转账请求
 *
 * @author yangyukang
 * @since 2024/12/26
 */
@Data
public class AlipayB2CTransferReq implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 转账金额，单位：分
     */
    @NotNull(message = "转账金额不能为空")
    private Long transferAmount;

    /**
     * 标识
     * identity_type=BANKCARD_ACCOUNT时，填写收款方银行卡号;
     * identity_type=ALIPAY_USER_ID 时，填写支付宝用户UID;
     * identity_type=ALIPAY_LOGON_ID 时，填写支付宝登录号;
     * 必填
     */
    @NotBlank(message = "标识不能为空")
    private String identity;

    /**
     * 标识类型
     * BANKCARD_ACCOUNT：收款方银行卡号
     * ALIPAY_USER_ID：支付宝会员的用户 ID，可通过 获取会员信息 能力获取。
     * ALIPAY_LOGON_ID：支付宝登录号，支持邮箱和手机号格式。
     * 必填
     * @see cn.com.duiba.quanyi.goods.service.api.enums.order.supplier.AlipayTransferIdentityTypeEnum
     */
    @NotBlank(message = "标识类型不能为空")
    private String identityType;

    /**
     * 支付宝分配给开发者的应用ID
     * 必选，最大长度32
     */
    @NotBlank(message = "appId不能为空")
    @Size(max = 32, message = "appId不能超过32")
    private String appId;

    /**
     * 收款方真实姓名
     */
    private String payeeName;

    /**
     * 转账标题
     */
    private String transferTitle;

    /**
     * 转账备注
     */
    private String transferRemark;

    /**
     * 业务场景
     * @see AlipayTransferBizSceneEnum
     */
    @NotBlank(message = "业务场景不能为空")
    private String bizScene;

    /**
     * 产品码
     * @see AlipayTransferProductCodeEnum
     */
    @NotBlank(message = "产品码不能为空")
    private String productCode;
} 