package cn.com.duiba.supplier.channel.service.api.dto.request.dingtalk;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

import java.util.List;

/**
 * 添加钉盘权限请求
 *
 * @author xuzhigang
 * @date 2025/01/20 10:00
 **/
@Data
@ToString(callSuper = true)
@EqualsAndHashCode(callSuper = true)
public class AddPermissionReq extends StorageRequest {

    /**
     * 文件或文件夹ID
     */
    private String dentryId;

    /**
     * 操作者unionId
     */
    private String unionId;

    /**
     * 权限角色Id。
     * OWNER：拥有者
     * MANAGER：管理者
     * EDITOR：编辑者
     * DOWNLOADER：下载者
     * READER：查看者
     */
    private String roleId;

    /**
     * 权限成员列表
     */
    private List<PermissionMember> members;

    /**
     * 可选参数
     */
    private PermissionOption option;

    /**
     * 权限成员
     */
    @Data
    public static class PermissionMember {
        /**
         * 权限成员类型：
         * ORG：企业
         * DEPT：部门
         * TAG：自定义tag
         * CONVERSATION：会话
         * USER：用户
         */
        private String type;

        /**
         * 权限成员id。
         * 如果type参数值为ORG，该参数值传企业corpId。
         * 如果type参数值为DEPT，该参数值传部门deptId。
         * 企业内部应用，调用获取部门列表接口获取dept_id参数值。
         * 第三方企业应用，调用获取部门列表接口获取dept_id参数值。
         * 如果type参数值为TAG，该参数值传tag名称。
         * 如果type参数值为CONVERSATION，该参数值传会话openConversationId。
         * 企业内部应用：
         * 通过创建群会话接口获取openConversationId参数值。
         * 通过创建场景群接口获取open_conversation_id参数值。
         * 第三方企业应用，通过创建场景群接口获取open_conversation_id参数值。
         * 如果type参数值为USER，该参数传用户unionId。
         * 企业内部应用，调用查询用户详情接口获取unionid参数值。
         * 第三方企业应用，调用查询用户详情接口获取unionid参数值。
         */
        private String id;

        /**
         * 权限归属的企业corpId。
         * type为DEPT或TAG时，该参数必填。
         * type为USER时，该参数选填。
         */
        private String corpId;
    }

    @Data
    public static class PermissionOption {
        /**
         * 授权有效时长，单位秒，仅支持APP空间类型。
         * 被添加权限的空间类型为APP时，该字段有效，最大3600。
         * 被添加权限的空间类型为USER时，该字段无效，默认永久有效。
         */
        public Long duration;
    }
} 