package cn.com.duiba.supplier.channel.service.api.dto.request.dingtalk;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

/**
 * @author xuzhigang
 * @date 2025/4/3 11:11
 **/
@Data
@ToString(callSuper = true)
@EqualsAndHashCode(callSuper = true)
public class TerminateApprovalInstanceRequest extends BaseRequest {
    private static final long serialVersionUID = -8251456792356425921L;

    /**
     * 审批实例id
     */
    private String processInstanceId;

    /**
     * 是否通过系统操作
     * true：由系统直接终止
     * false：由指定的操作者终止（需要传发起人才能撤销）
     */
    private Boolean isSystem;

    /**
     * 终止说明
     */
    private String remark;

    /**
     * 操作人的用户id
     * 当isSystem为false时，该参数必传（需要传发起人才能撤销）。
     */
    private String operatingUserId;
}
