package cn.com.duiba.supplier.channel.service.api.dto.request.wx.favor;

import lombok.Data;

import java.io.Serializable;

/**
 * @author zzy
 * @create 2025/06/24 19:42
 **/
@Data
public class WxFavorApplyBankMultiActivityReq implements Serializable {
    private static final long serialVersionUID = -8816796525592300934L;
    /**
     * 商户号 调用接口使用，必填
     */
    private String mchId;

    /**
     * openid 　必填 string(128)
     * 【用户标识】用户在商户appid下的唯一标识。
     * 校验规则：该openid需要与接口传入中的appid有对应关系。
     */
    private String openId;

    /**
     * appid 　必填 string(128)
     * 【公众账号ID】微信为发券方商户分配的公众账号ID，接口传入的所有appid应该为公众号的appid（在mp.weixin.qq.com申请的）或APP的appid（在open.weixin.qq.com申请的）。
     * 校验规则：
     * 1、该appid需要与接口传入中的openid有对应关系；
     * 2、该appid需要与调用接口的商户号（即请求头中的商户号）有绑定关系，若未绑定，可参考该指引完成绑定（
     */
    private String appId;

    /**
     * stock_id 必填  string(20)
     * 【批次号】批次号，是否指定批次号查询，填写available_mchid，该字段不生效。
     */
    private String stockId;
    /**
     * activity_id 必填  string(20)
     * 【批次号】批次号，是否指定批次号查询，填写available_mchid，该字段不生效。
     */
    private String activityId;
    /**
     * out_request_no 必填 string
     * 【商户单据号】 商户此次发放凭据号（格式：商户ID+日期+流水号），商户侧需保持唯一性
     */
    private String outRequestNo;

    /**
     * stock_creator_mchid  必填 string
     * 【创建批次的商户号】 批次创建方商户号
     */
    private String stockCreatorMchId;
}
