package cn.com.duiba.supplier.channel.service.api.dto.response.alipay.transfer;

import java.io.Serializable;

import lombok.Data;

/**
 * 支付宝B2C转账响应
 *
 * @author yangyukang
 * @since 2024/12/26
 */
@Data
public class AlipayB2CTransferResp implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 商户订单号
     */
    private String outBizNo;

    /**
     * 支付宝转账订单号
     */
    private String orderId;

    /**
     * 支付宝支付资金流水号
     */
    private String payFundOrderId;

    /**
     * 转账状态
     */
    private String status;

    /**
     * 转账子状态
     */
    private String subStatus;

    /**
     * 订单支付时间
     */
    private String transDate;

    /**
     * 清算机构流水号
     */
    private String settleSerialNo;

    /**
     * 转账金额，单位：分
     */
    private Long transferAmount;

    /**
     * 错误码
     */
    private String errorCode;

    /**
     * 错误描述
     */
    private String errorMsg;
} 