package cn.com.duiba.supplier.channel.service.api.dto.response.dingtalk;

import lombok.Data;

import java.io.Serializable;
import java.util.List;
import java.util.Map;

/**
 * @author xuzhigang
 * @date 2024/10/29 21:33
 **/
@Data
public class ApprovalSchemaContentItemProps implements Serializable {
    private static final long serialVersionUID = 6562165861164365878L;

    /**
     * 加班套件4.0新增 加班明细名称。
     */
    public String actionName;

    /**
     * textNote的样式，取值：
     * top：顶部
     * middle：中部
     * bottom：底部
     */
    public String align;

    /**
     * ISV 微应用 appId，用于ISV身份权限识别，ISV可获得相应数据。
     */
     public Long appId;

    /**
     * 套件是否开启异步获取分条件规则，取值：
     * true：是
     * false：否
     */
    public Boolean asyncCondition;

    /**
     * 请假、出差、外出、加班类型标签。
     */
    public String attendTypeLabel;

    /**
     * 表单关联控件列表。
     */
    public List<ApprovalSchemaContentItemPropsBehaviorLinkPage> behaviorLinkage;

    /**
     * 控件业务自定义别名。
     */
    public String bizAlias;

    /**
     * 业务套件类型。
     */
    public String bizType;

    /**
     * 套件内子组件可见性，取值：
     * true：是
     * false：否
     */
    public Map<String, Boolean> childFieldVisible;

    /**
     * 内部联系人choice，取值：
     * 1：多选
     * 0：单选
     */
    public Integer choice;

    /**
     * common field的commonBizType。
     */
    public String commonBizType;

    /**
     * 是否可编辑，取值：
     * true：是
     * false：否
     */
    public Boolean disabled;

    /**
     * 是否自动计算时长，取值：
     * true：是
     * false：否
     */
    public Boolean duration;

    /**
     * 兼容字段。
     */
    public String durationLabel;

    /**
     * e签宝专用标识。
     */
    public Boolean eSign;

    /**
     * 套件值是否打平，取值：
     * true：是
     * false：否
     */
    public Boolean extract;

    /**
     * 关联表单中的fields存储
     */
    public String fieldsInfo;

    /**
     * 时间格式(DDDateField和DDDateRangeField)。
     */
    public String format;

    /**
     * 公式。
     */
    public String formula;

    /**
     * 加班套件4.0新增 加班明细是否隐藏，取值：
     * true：是
     * false：否
     */
    public Boolean hidden;

    /**
     * textnote在详情页是否隐藏，取值：
     * true：是
     * false：否
     */
    public Boolean hiddenInApprovalDetail;

    /**
     * 加班套件4.0新增，加班明细是否隐藏标签，取值：
     * true：是
     * false：否
     */
    public Boolean hideLabel;

    /**
     * 兼容出勤套件类型。
     */
    public List<Map<String, String>> holidayOptions;

    /**
     * 控件 id。
     */
    public String id;

    /**
     * 控件名称。
     */
    public String label;

    /**
     * label是否可修改，取值：
     * true：不可修改
     * false：可修改
     */
    public Boolean labelEditableFreeze;

    /**
     * 说明文案的链接地址。
     */
    public String link;

    /**
     * 加班套件4.0新增 加班明细描述。
     */
    public String mainTitle;

    /**
     * 是否参与打印，取值：
     * 1：不打印
     * 0：打印
     */
    public String notPrint;

    /**
     * 是否需要大写，默认是需要，取值：
     * 1：不需要
     * 0 或空：需要
     */
    public String notUpper;

    /**
     * 选项内容列表，提供给业务方更多的选择器操作。
     */
    public List<ApprovalSchemaContentItemPropsObjOptions> objOptions;

    /**
     * 单选框选项值。
     */
    public java.util.List<String> options;

    /**
     * 是否有支付属性，取值：
     * true：是
     * false：否
     */
    public Boolean payEnable;

    /**
     * 占位符。
     */
    public String placeholder;

    /**
     * 同步到考勤, 表示是否设置为员工状态。
     */
    public ApprovalSchemaContentItemPropsPush push;

    /**
     * 是否推送到考勤, 子类型(DDSelectField)，取值：
     * true：是
     * false：否
     */
    public Boolean pushToAttendance;

    /**
     * 是否推送管理日历(DDDateRangeField, 该属性为兼容保留)，取值：
     * 1：推送
     * 0：不推送
     */
    public Integer pushToCalendar;

    /**
     * 是否必填，取值：
     * true：是
     * false：否
     */
    public Boolean required;

    /**
     * 必填是否可修改，取值：
     * true：不可修改
     * false：可修改
     */
    public Boolean requiredEditableFreeze;

    /**
     * 兼容出勤套件类型
     */
    public Boolean showAttendOptions;

    /**
     * 是否开启员工状态，取值：
     * true：是
     * false：否
     */
    public Boolean staffStatusEnabled;

    /**
     * 需要计算总和的明细组件。
     */
    public List<ApprovalSchemaContentItemPropsStatField> statField;

    /**
     * 明细填写方式，枚举值：
     * list：列表
     * table：表格
     */
    public String tableViewMode;

    /**
     * 数字组件/日期区间组件单位属性。
     */
    public String unit;

    /**
     * 是否使用考勤日历，取值：
     * true：是
     * false：否
     */
    public Boolean useCalendar;

    /**
     * 明细打印排版方式，取值：
     * true：纵向
     * false：横向
     */
    public Boolean verticalPrint;
}
