package cn.com.duiba.supplier.channel.service.api.dto.response.dingtalk;

import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * @author xuzhigang
 * @date 2024/10/19 10:08
 **/
@Data
public class UserDetailResponse implements Serializable {
    private static final long serialVersionUID = 3730608114967162252L;


    /**
     * 是否激活
     */
    private Boolean active;
    /**
     * 是否管理员
     */
    private Boolean admin;
    /**
     * 头像
     */
    private String avatar;
    /**
     * 是否老板
     */
    private Boolean boss;
    /**
     * 所属部门id列表
     */
    private List<Long> deptIdList;
    /**
     * 员工邮箱
     */
    private String email;
    /**
     * 是否专属帐号
     */
    private Boolean exclusiveAccount;
    /**
     * 专属帐号类型：{sso: 企业自定义idp;dingtalk: 钉钉idp}
     */
    private String exclusiveAccountType;
    /**
     * 扩展属性，长度最大2000个字符。可以设置多种属性（手机上最多显示10个扩展属性，具体显示哪些属性，请到OA管理后台->设置->通讯录信息设置和OA管理后台->设置->手机端显示信息设置）。 该字段的值支持链接类型填写，同时链接支持变量通配符自动替换，目前支持通配符有：userid，corpid。示例： [工位地址](http:www.dingtalk.com?userid=#userid#&corpid=#corpid#)
     */
    private String extension;
    /**
     * 是否号码隐藏。隐藏手机号后，手机号在个人资料页隐藏，但仍可对其发DING、发起钉钉免费商务电话。
     */
    private Boolean hideMobile;
    /**
     * 入职时间，Unix时间戳，单位ms。
     */
    private Long hiredDate;
    /**
     * 员工工号
     */
    private String jobNumber;
    /**
     * 专属帐号登录名
     */
    private String loginId;
    /**
     * 主管的ID，仅限企业内部开发调用
     */
    private String managerUserid;
    /**
     * 手机号码
     */
    private String mobile;
    /**
     * 员工名称
     */
    private String name;
    /**
     * 员工的企业邮箱
     */
    private String orgEmail;
    /**
     * 企业邮箱类型（profession：标准版，base：基础版）
     */
    private String orgEmailType;
    /**
     * 是否实名认证
     */
    private Boolean realAuthed;
    /**
     * 备注
     */
    private String remark;
    /**
     * 是否高管
     */
    private Boolean senior;
    /**
     * 国际电话区号
     */
    private String stateCode;
    /**
     * 分机号
     */
    private String telephone;
    /**
     * 职位
     */
    private String title;
    /**
     * 员工在当前开发者企业账号范围内的唯一标识
     */
    private String unionid;
    /**
     * 用户id
     */
    private String userid;
    /**
     * 办公地点
     */
    private String workPlace;
}
