package cn.com.duiba.supplier.channel.service.api.dto.response.douyin;

import lombok.Data;

import java.io.Serializable;

/**
 * 抖音回调返回体
 */
@Data
public class DouYinCallBackResp implements Serializable {


    public static final String SUCCESS = "SUCCESS";

    public static final String FAIL = "FAIL";
    private static final long serialVersionUID = 7989235756829942346L;

    /**
     * 错误码 SUCCESS为接收成功，其他错误码为失败
     * 示例值：FAIL
     */
    private String code;

    /**
     * 返回信息，如非空为错误原因
     * 示例值：失败
     */
    private String message;

    /**
     * 抖音回调信息
     */
    private CallBackInfo callBackInfo;


    public static DouYinCallBackResp success() {
        DouYinCallBackResp douYinCallBackResp = new DouYinCallBackResp();
        douYinCallBackResp.setCode(SUCCESS);
        return douYinCallBackResp;
    }
    public static DouYinCallBackResp fail(String message) {
        DouYinCallBackResp douYinCallBackResp = new DouYinCallBackResp();
        douYinCallBackResp.setCode(FAIL);
        douYinCallBackResp.setMessage(message);
        return douYinCallBackResp;
    }

}
