package cn.com.duiba.supplier.channel.service.api.dto.response.jd;

import java.io.Serializable;

import lombok.Data;

/**
 * 京东外卖验证码发送响应
 *
 * @author yangyukang
 * @since 2024/12/19
 */
@Data
public class JdWaiMaiZcSmsCodeResp implements Serializable {

    private static final long serialVersionUID = 7022897259613176234L;

    /**
     * 是否成功
     */
    private boolean success;

    /**
     * 错误信息
     */
    private String errorMsg;

    /**
     * 附加信息(Json形式返回)
     */
    private JdWaiMaiZcSmsCodeDataResp data;

    public static JdWaiMaiZcSmsCodeResp buildSuccess(JdWaiMaiZcSmsCodeDataResp data) {
        JdWaiMaiZcSmsCodeResp jdSmsResp = new JdWaiMaiZcSmsCodeResp();
        jdSmsResp.setSuccess(true);
        jdSmsResp.setData(data);
        return jdSmsResp;
    }

    public static JdWaiMaiZcSmsCodeResp buildError(String errorMsg) {
        JdWaiMaiZcSmsCodeResp jdSmsResp = new JdWaiMaiZcSmsCodeResp();
        jdSmsResp.setSuccess(false);
        jdSmsResp.setErrorMsg(errorMsg);
        return jdSmsResp;
    }

} 