package cn.com.duiba.supplier.channel.service.api.enums.alipay;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * 支付宝转账业务场景枚举
 * @author yangyukang
 * @date 2025-01-26
 */
@Getter
@AllArgsConstructor
public enum AlipayTransferBizSceneEnum {
    
    /**
     * 单笔无密转账到支付宝，B2C现金红包
     */
    DIRECT_TRANSFER("DIRECT_TRANSFER", "单笔无密转账到支付宝，B2C现金红包"),
    
    /**
     * C2C现金红包-领红包
     */
    PERSONAL_COLLECTION("PERSONAL_COLLECTION", "C2C现金红包-领红包"),
    
    /**
     * CAE代扣
     */
    CAE_TRANSFER("CAE_TRANSFER", "CAE代扣"),
    
    /**
     * 余额充值到记账本
     */
    DIRECT_ALLOCATION("DIRECT_ALLOCATION", "余额充值到记账本"),
    
    /**
     * 资金调拨转账
     */
    DIRECT_ALLOCATION_TRANSFER("DIRECT_ALLOCATION_TRANSFER", "资金调拨转账"),
    
    /**
     * 记账本间资金调拨
     */
    ENTRUST_ALLOCATION("ENTRUST_ALLOCATION", "记账本间资金调拨"),
    
    /**
     * 调拨并转账
     */
    ENTRUST_ALLOCATION_TRANSFER("ENTRUST_ALLOCATION_TRANSFER", "调拨并转账"),
    
    /**
     * 记账本代发
     */
    ENTRUST_TRANSFER("ENTRUST_TRANSFER", "记账本代发"),
    
    /**
     * 境外结汇入金
     */
    OVERSEA_FCY_TRANSFER("OVERSEA_FCY_TRANSFER", "境外结汇入金"),
    
    /**
     * 红包资金发放
     */
    THIRDPARTY_PERSONAL_COLLECTION("THIRDPARTY_PERSONAL_COLLECTION", "红包资金发放"),
    
    /**
     * 红包资金领取
     */
    THIRDPARTY_PERSONAL_COLLECTION_CONFIRM("THIRDPARTY_PERSONAL_COLLECTION_CONFIRM", "红包资金领取"),
    
    /**
     * 大额无限付
     */
    UNLIMITED_PAY("UNLIMITED_PAY", "大额无限付");

    /**
     * 业务场景代码
     */
    private final String code;
    
    /**
     * 描述
     */
    private final String desc;
} 