package cn.com.duiba.supplier.channel.service.api.enums.channel;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Arrays;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * @author: LuHui
 * @date: 2024/8/29 10:56
 * @description:
 */
@Getter
@AllArgsConstructor
public enum HanGongYunNotifyTypeEnum {
    BILL_DONE("bill_done"),
    ;

    private final String type;


    private static final Map<String, HanGongYunNotifyTypeEnum> typeEnumMap = Arrays.stream(values())
            .collect(Collectors.toMap(HanGongYunNotifyTypeEnum::getType, Function.identity(), (v1, v2) -> v1));

    public static HanGongYunNotifyTypeEnum getByType(String type) {
        return typeEnumMap.get(type);
    }

}
