package cn.com.duiba.supplier.channel.service.api.enums.channel;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 企迈消息回调类型
 * @author lizhi
 * @date 2024/2/2 14:22
 */
@Getter
@AllArgsConstructor
public enum QiMaiMessageTypeEnum {
    VOUCHAER_TO_ACCOUNT(1, "券到账"),
    VOUCHAER_CHANGER(2, "券状态变更"),
    EXPIRED(3, "过期"),
    ;
    /**
     * 类型
     */
    private final Integer type;

    /**
     * 描述
     */
    private final String desc;


    private static final Map<Integer, QiMaiMessageTypeEnum> ENUM_MAP = Collections.unmodifiableMap(Arrays.stream(values()).collect(Collectors.toMap(QiMaiMessageTypeEnum::getType, Function.identity(), (v1, v2) -> v2)));

    public static QiMaiMessageTypeEnum getByType(Integer type) {
        if (type == null) {
            return null;
        }
        return ENUM_MAP.get(type);
    }

}
