package cn.com.duiba.supplier.channel.service.api.enums.channel;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Arrays;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

@Getter
@AllArgsConstructor
public enum ShenBianYunPaymentTypeEnum {

    BANK_CARD(0, "银行卡", "bank"),
    ALI_PAY(1, "支付宝", "alipay"),
    WX(2, "微信","wx"),
    ;

    private static final Map<Integer, ShenBianYunPaymentTypeEnum> codeEnumMap = Arrays.stream(values())
            .collect(Collectors.toMap(ShenBianYunPaymentTypeEnum::getCode, Function.identity(), (v1, v2) -> v1));

    private static final Map<String, ShenBianYunPaymentTypeEnum> abbreviationEnumMap = Arrays.stream(values())
            .collect(Collectors.toMap(ShenBianYunPaymentTypeEnum::getAbbreviation, Function.identity(), (v1, v2) -> v1));

    public static ShenBianYunPaymentTypeEnum getByCode(Integer code) {
        return codeEnumMap.get(code);
    }

    public static ShenBianYunPaymentTypeEnum getByAbbreviation(String abbreviation) {
        return abbreviationEnumMap.get(abbreviation);
    }

    private final Integer code;

    private final String desc;

    private final String abbreviation;
}
