package cn.com.duiba.supplier.channel.service.api.enums.channel;

import lombok.Getter;
import lombok.RequiredArgsConstructor;

import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 盛马提交状态枚举
 *
 * @author wangguanhua
 */
@RequiredArgsConstructor
@Getter
public enum ShengmaCodeEnum {

    SUCCESS(0, "请求成功"),
    SYSTEM_ERROR(500, "系统异常"),
    MISSING_PARAMETER(10000, "请传入参数"),
    INVALID_METHOD(10001, "请传入正确method"),
    INVALID_TIMESTAMP(10002, "请传入正确时间戳"),
    EXPIRED_REQUEST(10003, "请求已过期"),
    MISSING_ORDER_NUMBER(10004, "请传入商户订单流水号"),
    INVALID_RECHARGE_AMOUNT(10005, "请传入正确的充值数量"),
    INVALID_PRODUCT_CODE(10006, "请传入正确的产品编码"),
    MISSING_ORDER_ID(10007, "平台订单号或商户流水号至少传入一个"),
    INVALID_PLATFORM_ORDER_ID(10008, "平台订单号错误"),
    MISSING_PRODUCT_CODE_FOR_QUERY(10009, "请传入查询产品编码"),
    INVALID_NUMERIC_PRODUCT_CODE(10010, "请传入正确的产品编码"),
    INVALID_MERCHANT(10011, "无效商户"),
    SIGNATURE_ERROR(10012, "签名错误"),
    IP_NOT_IN_WHITELIST(10013, "ip不在白名单，请自行添加"),
    PRODUCT_NOT_AUTHORIZED(10014, "产品未授权"),
    ORDER_EXISTS(10015, "订单已存在"),
    PRODUCT_NOT_FOUND_OR_OFFLINE(10016, "产品不存在或产品已下线"),
    BLACKLISTED_USER(10017, "黑名单用户"),
    DAILY_RECHARGE_LIMIT_REACHED(10018, "该账号当日充值次数达到上线"),
    INVALID_ACCOUNT_FORMAT(10019, "账号格式错误"),
    PRODUCT_DOES_NOT_SUPPORT_MULTI_RECHARGE(10020, "该产品不支持倍充"),
    PRODUCT_CONFIGURATION_ERROR(10021, "商品配置错误"),
    INSUFFICIENT_BALANCE(10022, "余额不足"),
    ORDER_NOT_FOUND(10023, "未查询到订单"),
    PRODUCT_NOT_FOUND(10024, "产品不存在"),
    PRODUCT_OFFLINE(10025, "产品已下线"),
    PRICE_CONTROL(10026, "限价控制"),
    JD_ECARD_SMS_SEND_FAILED(10027, "京东e卡短信验证码发送失败"),
    STOCK_INSUFFICIENT(10028, "库存不足"),
    RECHARGE_ACCOUNT_REQUIRED(10029, "充值账号不能为空"),
    OTHER_FAILURE(10100, "其他失败");
    ;

    private final Integer code;

    private final String desc;

    private static final Map<Integer, ShengmaCodeEnum> ENUM_MAP = Collections.unmodifiableMap(Arrays.stream(values()).collect(Collectors.toMap(ShengmaCodeEnum::getCode, Function.identity(), (v1, v2) -> v2)));

    /**
     * 根据枚举code获取枚举
     *
     * @param code 枚举code
     * @return 枚举
     */
    public static ShengmaCodeEnum getByCode(Integer code) {
        if (code == null) {
            return null;
        }
        return ENUM_MAP.get(code);
    }
}
