package cn.com.duiba.supplier.channel.service.api.enums.channel;

import lombok.Getter;
import lombok.RequiredArgsConstructor;

/**
 * @author nongfu
 * @Date 2025/4/21 14:02
 */
@RequiredArgsConstructor
@Getter
public enum UnionPayNotifyStatusEnum {

    /**
     * 01：优惠券承兑
     */
    COUPON_REDEEMED("01", "优惠券承兑"),

    /**
     * 02：优惠券返还
     */
    COUPON_RETURNED("02", "优惠券返还"),

    /**
     * 03：优惠券无操作
     */
    COUPON_NO_ACTION("03", "优惠券无操作"),

    /**
     * 04：优惠券获取
     */
    COUPON_RECEIVED("04", "优惠券获取"),

    /**
     * 05：优惠券删除
     */
    COUPON_DELETED("05", "优惠券删除"),

    /**
     * 06：优惠券过期
     */
    COUPON_EXPIRED("06", "优惠券过期");

    private final String code;
    private final String description;
}
