package cn.com.duiba.supplier.channel.service.api.enums.channel;

import cn.com.duiba.boot.exception.BizException;
import lombok.Getter;
import lombok.RequiredArgsConstructor;

/**
 * @author yyk
 * @since 2024/6/22
 */
@RequiredArgsConstructor
@Getter
public enum WanHengCodeEnum {

    PENDING_PROCESSING("0", "待处理"),
    SUCCESS("1", "成功"),
    PROCESSING("2", "充值中"),
    FAILED("3", "充值失败"),
    ;
    public static WanHengCodeEnum getByCode(String code) throws BizException {
        for (WanHengCodeEnum value : values()) {
            if (value.getCode().equals(code)) {
                return value;
            }
        }
        throw new BizException("未找到对应的枚举值");
    }

    private final String code;

    private final String description;

}
