package cn.com.duiba.supplier.channel.service.api.remoteservice.alipay;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.supplier.channel.service.api.dto.request.alipay.AlipayUserRealNameVerificationParam;
import cn.com.duiba.supplier.channel.service.api.dto.response.alipay.AliPaySystemOauthTokenResp;
import cn.com.duiba.supplier.channel.service.api.dto.response.alipay.AlipayUserCertdocCertverifyConsultResp;

/**
 * 支付宝实名验证
 * @author nongfu
 * @Date 2025/6/13 18:37
 */
@AdvancedFeignClient
public interface RemoteAlipayUserRealNameApiService {

    /**
     * 用户实名预校验
     * @param param 参数
     * @return 支付宝验证ID
     * @throws
     */
    String userCertdocCertverifyPreconsultExecute(AlipayUserRealNameVerificationParam param) ;

    /**
     * 支付宝获取用户信息
     * @param appId 支付宝应用ID
     * @param authCode 授权码
     * @return 支付宝信息
     */
    AliPaySystemOauthTokenResp queryAlipaySystemOauthTokenByAuthCode(String appId, String authCode);

    /**
     * 用户实名校验结果
     *
     * @param appId
     * @param verifyId 验证ID
     * @param authToken 授权凭证，一般是用户授权后获取的access_token
     * @return
     * @throws BizException
     */
    AlipayUserCertdocCertverifyConsultResp userCertverifyResultExecute(String appId, String verifyId, String authToken) throws BizException;


}
