package cn.com.duiba.supplier.channel.service.api.remoteservice.conf;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.supplier.channel.service.api.dto.conf.WxpayMchCertConfSaveDto;
import cn.com.duiba.supplier.channel.service.api.dto.conf.WxpayMchConfCertDto;

import java.util.List;

/**
 * 微信支付商户配置
 * @author lizhi
 * @date 2023/8/19 17:50
 */
@AdvancedFeignClient
public interface RemoteWxpayMchCertConfService {

    /**
     * 新增微信商户号
     * @param dto
     * @return
     */
    Long addWxMch(WxpayMchCertConfSaveDto dto);

    /**
     * 更新微信商户号
     * @param dto
     * @return
     */
    Long updateWxMch(WxpayMchCertConfSaveDto dto);

    /**
     * 根据商户号、证书类型查询可用证书
     * @param mchId 商户ID
     * @param certType 证书类型
     * {@link cn.com.duiba.supplier.channel.service.enums.WxpayMchCertTypeEnum}
     * @return 微信支付商户证书列表
     */
    List<WxpayMchConfCertDto> selectByMchTypeWithLocal(String mchId, Integer certType);
}
