package cn.com.duiba.supplier.channel.service.api.remoteservice.dingtalk;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.supplier.channel.service.api.dto.dingtalk.DingTalkUserDetailDto;

import java.util.List;

/**
 * 钉钉用户表
 * @author kjj mybatis generator 
 * @date 2024-10-19
 */
@AdvancedFeignClient
public interface RemoteDingTalkUserService {

    /**
     * 用户id和appConfId查询用户详情信息
     * @param userId 用户id
     * @param appKey appKey
     * @return 钉钉用户
     */
    DingTalkUserDetailDto selectByUserIdAndAppKey(String userId, String appKey);

    /**
     * 新增或更新用户信息
     * @param userIds 用户id集合
     * @param appKey appKey
     * @return 执行结果
     */
    boolean batchSaveOrUpdate(List<String> userIds, String appKey);

    /**
     * 批量删除用户
     * @param userIds 用户id集合
     * @param appKey appKey
     * @return 执行结果
     */
    boolean batchDelete(List<String> userIds, String appKey);
}