package cn.com.duiba.supplier.channel.service.api.remoteservice.order;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.supplier.channel.service.api.dto.response.order.ChannelOrderDto;
import cn.com.duiba.supplier.channel.service.api.enums.order.BizTypeEnum;

import java.util.List;

/**
 * @author: LuHui
 * @date: 2024/2/22 18:11
 * @description:
 */
@AdvancedFeignClient
public interface RemoteChannelOrderService {

    /**
     * 根据三方唯一单号查询
     *
     * @param respSerialNo 供应商三方唯一单号
     * @param channelType  渠道类型
     * @return 订单
     */
    ChannelOrderDto selectByRespSerialNo(String respSerialNo, Integer channelType);


    /**
     * select by out biz no
     *
     * @param outBizNo        out biz no
     * @return 订单
     */
    ChannelOrderDto selectByOutBizNo(String outBizNo);

    /**
     * select by out biz nos
     * @param outBizNos
     * @return
     */
    List<ChannelOrderDto>  selectByOutBizNos(List<String> outBizNos);

    /**
     * 根据bizNos查询
     *
     * @param bizNos   业务方唯一单号集合
     * @return 结果
     */
    List<ChannelOrderDto> selectByBizNos(List<String> bizNos);

    /**
     * 根据业务类型+业务单号查询
     * @param bizType 业务类型
     *                {@link BizTypeEnum}
     * @param bizNo 业务方唯一单号
     * @return 订单
     */
    ChannelOrderDto selectByBiz(Integer bizType, String bizNo);
}
