package cn.com.duiba.supplier.channel.service.api.remoteservice.supplier;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

import java.util.TreeMap;

/**
 * RemoteMeiTuanService
 *
 * @author cxw
 * @since 2024/7/22
 */
@AdvancedFeignClient
public interface RemoteMeiTuanService {

    /**
     * 验签
     *
     * @param body  请求体中的信息
     * @return 签名是否正确
     */
    boolean checkSign(String body);

    /**
     * 签名
     * @param merchantId 商户id
     * @param paramMap 请求参数
     * @return 签名
     */
    String sign(Long merchantId,TreeMap<String, Object> paramMap);

}
