package cn.com.duiba.supplier.channel.service.api.remoteservice.supplier;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;


/**
 * 众联
 *
 * @author wangguanhua
 */
@AdvancedFeignClient
public interface RemoteZhonglianService {

    /**
     * 解密并验签
     *
     * @param mchId   mch id
     * @param encrypt encrypt
     * @return {@link String }
     * @throws BizException biz exception
     */
    String decryptAndCheckSign(String mchId, String encrypt) throws BizException;

    /**
     * 参数加密
     *
     * @param mchId mch id
     * @param t     t
     * @return {@link String }
     */
    <T> String encrypt(String mchId, T t);
}
