/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.supplier.channel.service.api.enums.express;

import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

public enum ExpressTypeEnum {
    KUAIDI100(1, "\u5feb\u9012100");

    private static final Map<Integer, ExpressTypeEnum> ENUM_MAP;
    private final Integer type;
    private final String desc;

    public static ExpressTypeEnum getByType(Integer type) {
        if (type == null) {
            return null;
        }
        return ENUM_MAP.get(type);
    }

    public Integer getType() {
        return this.type;
    }

    public String getDesc() {
        return this.desc;
    }

    private ExpressTypeEnum(Integer type, String desc) {
        this.type = type;
        this.desc = desc;
    }

    static {
        ENUM_MAP = Collections.unmodifiableMap(Arrays.stream(ExpressTypeEnum.values()).collect(Collectors.toMap(ExpressTypeEnum::getType, Function.identity(), (v1, v2) -> v2)));
    }
}

