package cn.com.duiba.supplier.channel.service.api.dto.response.dingtalk;

import lombok.Data;

import java.io.Serializable;

/**
 * @author xuzhigang
 * @date 2024/10/22 13:38
 **/
@Data
public class ApprovalProcessForecastWorkFlowActor implements Serializable {
    private static final long serialVersionUID = -3896625098794635033L;

    /**
     * 节点激活类型，取值：
     * ALL：并行
     * ONE_BY_ONE：串行
     */
    public String actorActivateType;

    /**
     * 节点操作人 key。
     */
    public String actorKey;

    /**
     * 节点操作人选择范围。
     */
    public ApprovalProcessForecastWorkFlowActorSelectionRange actorSelectionRange;

    /**
     * 节点操作人选择范围类型，取值：
     * allStaff：全公司
     * approvals：指定成员
     * labels：角色
     */
    public String actorSelectionType;

    /**
     * 节点操作人类型，取值：
     * approver：审批人
     * notifier：抄送人
     * audit：办理人
     */
    public String actorType;

    /**
     * 是否允许多选，还是仅允许选一人。
     */
    public Boolean allowedMulti;

    /**
     * 节点审批方式，取值：
     * ONE_BY_ONE：依次审批
     * AND：会签审批
     * OR：或签审批
     */
    public String approvalMethod;

    /**
     * 节点审批类型，取值：
     * MANUAL：人工审批
     * AUTO_AGREE：自动通过
     * AUTO_REFUSE：自动拒绝
     */
    public String approvalType;

    /**
     * 该审批人节点在发起审批时是否必填。
     */
    public Boolean required;
}
