package cn.com.duiba.supplier.channel.service.api.dto.response.meituancoupon;

import lombok.Data;

import java.io.Serializable;

@Data
public class MeiTuanNotifyResp implements Serializable {

    private static final long serialVersionUID = 8108956781650173938L;
    /**
     * 商户编号ID，商户认证后从服务平台接入指南中获取
     * 必填
     */
    private Long merchantId;

    /**
     * 通知流水号
     *      此参数是券变更流水号
     * 必填
     */
    private Long notifyId;

    /**
     * 券码
     *      此参数是券码
     * 必填
     */
    private Long couponCode;

    /**
     * 券批次ID
     *      此参数是券批次ID
     * 必填
     */
    private Long couponBatchId;

    /**
     * 事件类型
     *  券变更类型：2-核销，3-退券，5-过期
     *  必填
     */
    private String eventType;

    /**
     * 券类型
     *  券类型：1-支付券
     */
    private String couponType;

    /**
     * 优惠金额（分）
     */
    private String discountAmt;

    /**
     * 变更时间
     *  格式：yyyy-MM-dd HH:mm:ss
     */
    private String changeTime;

    /**
     * 通知时间
     *  格式：yyyy-MM-dd HH:mm:ss
     */
    private String notifyTime;


}
