package cn.com.duiba.supplier.channel.service.api.enums.channel;

import java.util.Objects;

/**
 * 抖音支付券状态
 */
public enum DouYinPayNotifyStatusEnum {


    INIT("INIT", "待使用"),
    FREEZE("FREEZE", "已冻结"),
    USED("USED", "已核销"),
    CNCL("CNCL", "已失效"),
    FEFUND("FEFUND", "已退款（订单整单退款后支付券返回）");

    private String code;
    private String message;

    DouYinPayNotifyStatusEnum(String code, String message) {
        this.code = code;
        this.message = message;
    }

    public String getCode() {
        return code;
    }

    public String getMessage() {
        return message;
    }

    public static DouYinPayNotifyStatusEnum getByCode(String code) {
        for (DouYinPayNotifyStatusEnum value : values()) {
            if (Objects.equals(value.getCode(), code)) {
                return value;
            }
        }
        return null;
    }
}
