package cn.com.duiba.supplier.channel.service.api.enums.channel;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * @author lizhi
 * @date 2025/2/24 18:13
 */
@Getter
@AllArgsConstructor
public enum JingLanTuHuVoucherStatusEnum {

    NOT_USED(0, "未使用"),
    IN_USE(1, "使用中"),
    USED(2, "已使用"),
    EXPIRED(3, "已过期"),
    UNKNOWN_ERROR(-1, "未知错误"),
    ;
    
    private final Integer status;
    
    private final String desc;
    
    private static final Map<Integer, JingLanTuHuVoucherStatusEnum> ENUM_MAP = Collections.unmodifiableMap(Arrays.stream(values()).collect(Collectors.toMap(JingLanTuHuVoucherStatusEnum::getStatus, Function.identity(), (v1, v2) -> v2)));
    
    /**
     * 根据枚举值获取枚举
     * @param status 枚举值
     * @return 枚举
     */
    public static JingLanTuHuVoucherStatusEnum getByStatus(Integer status) {
        if (status == null) {
            return null;
        }
        return ENUM_MAP.get(status);
    }
}
