package com.qimencloud.api.sceneqimen.request;

import com.taobao.api.internal.mapping.ApiBodyField;
import com.taobao.api.internal.util.RequestCheckUtils;
import java.util.Map;

import com.taobao.api.ApiRuleException;
import com.taobao.api.BaseTaobaoRequest;
import com.taobao.api.internal.util.TaobaoHashMap;
import com.taobao.api.Constants;


import com.qimencloud.api.sceneqimen.response.AlibabaMktcellInterplayExecuteReadResponse;

/**
 * TOP API(QimenCloud): qimen.alibaba.mktcell.interplay.execute.read request
 * 
 * @author top auto create
 * @since 1.0, 2022.11.29
 */
public class AlibabaMktcellInterplayExecuteReadRequest extends BaseTaobaoRequest<AlibabaMktcellInterplayExecuteReadResponse> {
     
     

	/** 
	* 请求API方法
	 */
	private String bizMethod;

	/** 
	* json字符串,请求API参数
	 */
	@ApiBodyField(value = "",fieldName = "bizParams")
	private String bizParams;

	/** 
	* 请求API类型
	 */
	private String bizType;

	/** 
	* userId加密后的openId
	 */
	private String openId;

	public void setBizMethod(String bizMethod) {
		this.bizMethod = bizMethod;
	}

	public String getBizMethod() {
		return this.bizMethod;
	}

	public void setBizParams(String bizParams) {
		this.bizParams = bizParams;
	}

	public String getBizParams() {
		return this.bizParams;
	}

	public void setBizType(String bizType) {
		this.bizType = bizType;
	}

	public String getBizType() {
		return this.bizType;
	}

	public void setOpenId(String openId) {
		this.openId = openId;
	}

	public String getOpenId() {
		return this.openId;
	}

     public String getApiMethodName() {
        return "qimen.alibaba.mktcell.interplay.execute.read";
     }

     private String topContentType = Constants.CONTENT_TYPE_JSON;

     public String getTopContentType() {
        return topContentType;
     }

     public void setTopContentType(String topContentType) {
         this.topContentType = topContentType;
     }

     private String topResponseType = Constants.RESPONSE_TYPE_QIMEN2;

     public String getTopResponseType() {
        return topResponseType;
     }

     public void setTopResponseType(String topResponseType) {
        this.topResponseType = topResponseType;
     }

    private String topApiVersion = "3.0";

     public String getTopApiVersion() {
        return this.topApiVersion;
     }

     public void setTopApiVersion(String topApiVersion) {
        this.topApiVersion = topApiVersion;
     }

     private String topApiFormat = Constants.FORMAT_JSON2;

     public String getTopApiFormat() {
     	return this.topApiFormat;
     }

     public void setTopApiFormat(String topApiFormat) {
     	this.topApiFormat = topApiFormat;
     }
     
     public Map<String, String> getTextParams() {		
		TaobaoHashMap txtParams = new TaobaoHashMap();
		txtParams.put("bizMethod", this.bizMethod);
		txtParams.put("bizType", this.bizType);
		txtParams.put("openId", this.openId);
		if(this.udfParams != null) {
			txtParams.putAll(this.udfParams);
		}
		return txtParams;
	}
     
     public Class<AlibabaMktcellInterplayExecuteReadResponse> getResponseClass() {
		return AlibabaMktcellInterplayExecuteReadResponse.class;
	}

     public void check() throws ApiRuleException {
		RequestCheckUtils.checkNotEmpty(bizMethod, "bizMethod");
		RequestCheckUtils.checkNotEmpty(bizParams, "bizParams");
		RequestCheckUtils.checkNotEmpty(bizType, "bizType");
		RequestCheckUtils.checkNotEmpty(openId, "openId");
     }
     


}