package com.qimencloud.api.sceneqimen.request;

import com.taobao.api.internal.mapping.ApiBodyField;
import com.taobao.api.internal.util.RequestCheckUtils;
import java.util.Map;

import com.taobao.api.ApiRuleException;
import com.taobao.api.BaseTaobaoRequest;
import com.taobao.api.internal.util.TaobaoHashMap;
import com.taobao.api.Constants;


import com.qimencloud.api.sceneqimen.response.AlibabaMktcellNftGetUserInfoResponse;

/**
 * TOP API(QimenCloud): qimen.alibaba.mktcell.nft.get.user.info request
 * 
 * @author top auto create
 * @since 1.0, 2023.01.09
 */
public class AlibabaMktcellNftGetUserInfoRequest extends BaseTaobaoRequest<AlibabaMktcellNftGetUserInfoResponse> {
     
     

	/** 
	* 用户唯一键
	 */
	@ApiBodyField(value = "",fieldName = "openid")
	private String openid;

	/** 
	* 用户信息
	 */
	@ApiBodyField(value = "",fieldName = "userInfo")
	private String userInfo;

	public void setOpenid(String openid) {
		this.openid = openid;
	}

	public String getOpenid() {
		return this.openid;
	}

	public void setUserInfo(String userInfo) {
		this.userInfo = userInfo;
	}

	public String getUserInfo() {
		return this.userInfo;
	}

     public String getApiMethodName() {
        return "qimen.alibaba.mktcell.nft.get.user.info";
     }

     private String topContentType = Constants.CONTENT_TYPE_JSON;

     public String getTopContentType() {
        return topContentType;
     }

     public void setTopContentType(String topContentType) {
         this.topContentType = topContentType;
     }

     private String topResponseType = Constants.RESPONSE_TYPE_QIMEN2;

     public String getTopResponseType() {
        return topResponseType;
     }

     public void setTopResponseType(String topResponseType) {
        this.topResponseType = topResponseType;
     }

    private String topApiVersion = "3.0";

     public String getTopApiVersion() {
        return this.topApiVersion;
     }

     public void setTopApiVersion(String topApiVersion) {
        this.topApiVersion = topApiVersion;
     }

     private String topApiFormat = Constants.FORMAT_JSON2;

     public String getTopApiFormat() {
     	return this.topApiFormat;
     }

     public void setTopApiFormat(String topApiFormat) {
     	this.topApiFormat = topApiFormat;
     }
     
     public Map<String, String> getTextParams() {		
		TaobaoHashMap txtParams = new TaobaoHashMap();
		if(this.udfParams != null) {
			txtParams.putAll(this.udfParams);
		}
		return txtParams;
	}
     
     public Class<AlibabaMktcellNftGetUserInfoResponse> getResponseClass() {
		return AlibabaMktcellNftGetUserInfoResponse.class;
	}

     public void check() throws ApiRuleException {
		RequestCheckUtils.checkNotEmpty(openid, "openid");
		RequestCheckUtils.checkNotEmpty(userInfo, "userInfo");
     }
     


}