package com.qimencloud.api.sceneqimen.request;

import com.taobao.api.internal.mapping.ApiBodyField;
import com.taobao.api.internal.util.RequestCheckUtils;
import java.util.Map;

import com.taobao.api.ApiRuleException;
import com.taobao.api.BaseTaobaoRequest;
import com.taobao.api.internal.util.TaobaoHashMap;
import com.taobao.api.Constants;


import com.qimencloud.api.sceneqimen.response.TaobaoCloudmallUserdataQueryResponse;

/**
 * TOP API(QimenCloud): qimen.taobao.cloudmall.userdata.query request
 * 
 * @author top auto create
 * @since 1.0, 2019.12.31
 */
public class TaobaoCloudmallUserdataQueryRequest extends BaseTaobaoRequest<TaobaoCloudmallUserdataQueryResponse> {
     
     

	/** 
	* 结束日期
	 */
	@ApiBodyField(value = "",fieldName = "endTime")
	private String endTime;

	/** 
	* 云Mall的ID
	 */
	@ApiBodyField(value = "",fieldName = "mallId")
	private Long mallId;

	/** 
	* 开始日期
	 */
	@ApiBodyField(value = "",fieldName = "startTime")
	private String startTime;

	public void setEndTime(String endTime) {
		this.endTime = endTime;
	}

	public String getEndTime() {
		return this.endTime;
	}

	public void setMallId(Long mallId) {
		this.mallId = mallId;
	}

	public Long getMallId() {
		return this.mallId;
	}

	public void setStartTime(String startTime) {
		this.startTime = startTime;
	}

	public String getStartTime() {
		return this.startTime;
	}

     public String getApiMethodName() {
        return "qimen.taobao.cloudmall.userdata.query";
     }

     private String topContentType = Constants.CONTENT_TYPE_JSON;

     public String getTopContentType() {
        return topContentType;
     }

     public void setTopContentType(String topContentType) {
         this.topContentType = topContentType;
     }

     private String topResponseType = Constants.RESPONSE_TYPE_QIMEN2;

     public String getTopResponseType() {
        return topResponseType;
     }

     public void setTopResponseType(String topResponseType) {
        this.topResponseType = topResponseType;
     }

    private String topApiVersion = "3.0";

     public String getTopApiVersion() {
        return this.topApiVersion;
     }

     public void setTopApiVersion(String topApiVersion) {
        this.topApiVersion = topApiVersion;
     }

     private String topApiFormat = Constants.FORMAT_JSON2;

     public String getTopApiFormat() {
     	return this.topApiFormat;
     }

     public void setTopApiFormat(String topApiFormat) {
     	this.topApiFormat = topApiFormat;
     }
     
     public Map<String, String> getTextParams() {		
		TaobaoHashMap txtParams = new TaobaoHashMap();
		if(this.udfParams != null) {
			txtParams.putAll(this.udfParams);
		}
		return txtParams;
	}
     
     public Class<TaobaoCloudmallUserdataQueryResponse> getResponseClass() {
		return TaobaoCloudmallUserdataQueryResponse.class;
	}

     public void check() throws ApiRuleException {
		RequestCheckUtils.checkNotEmpty(endTime, "endTime");
		RequestCheckUtils.checkNotEmpty(mallId, "mallId");
		RequestCheckUtils.checkNotEmpty(startTime, "startTime");
     }
     


}