package com.taobao.api.domain;

import java.util.List;
import com.taobao.api.internal.mapping.ApiField;
import com.taobao.api.internal.mapping.ApiListField;
import com.taobao.api.TaobaoObject;


/**
 * 批量发放请求
 *
 * @author top auto create
 * @since 1.0, null
 */
public class BatchSendRequest extends TaobaoObject {

	private static final long serialVersionUID = 3119416375335488866L;

	/**
	 * 发放者id
	 */
	@ApiField("purchaser_id")
	private Long purchaserId;

	/**
	 * 发放请求列表
	 */
	@ApiListField("request_list")
	@ApiField("benefit_send_request")
	private List<BenefitSendRequest> requestList;

	/**
	 * 事务id
	 */
	@ApiField("unique_id")
	private String uniqueId;


	public Long getPurchaserId() {
		return this.purchaserId;
	}
	public void setPurchaserId(Long purchaserId) {
		this.purchaserId = purchaserId;
	}

	public List<BenefitSendRequest> getRequestList() {
		return this.requestList;
	}
	public void setRequestList(List<BenefitSendRequest> requestList) {
		this.requestList = requestList;
	}

	public String getUniqueId() {
		return this.uniqueId;
	}
	public void setUniqueId(String uniqueId) {
		this.uniqueId = uniqueId;
	}

}
