package com.taobao.api.domain;

import java.util.List;
import com.taobao.api.internal.mapping.ApiField;
import com.taobao.api.internal.mapping.ApiListField;
import com.taobao.api.TaobaoObject;


/**
 * 权益中心发放回调消息
 *
 * @author top auto create
 * @since 1.0, null
 */
public class BenefitCallbackRequest extends TaobaoObject {

	private static final long serialVersionUID = 1819743122212731699L;

	/**
	 * 支付宝账户
	 */
	@ApiField("alipay_account_no")
	private String alipayAccountNo;

	/**
	 * 权益类型
	 */
	@ApiField("benefit_type")
	private Long benefitType;

	/**
	 * 异常码
	 */
	@ApiField("error_code")
	private String errorCode;

	/**
	 * 扩展字段
	 */
	@ApiField("feature")
	private String feature;

	/**
	 * 实例id
	 */
	@ApiListField("instance_ids")
	@ApiField("string")
	private List<String> instanceIds;

	/**
	 * 外部关联id(模板id)
	 */
	@ApiField("out_object_id")
	private String outObjectId;

	/**
	 * 采购者id
	 */
	@ApiField("purchaser_id")
	private Long purchaserId;

	/**
	 * 接收者id
	 */
	@ApiField("receiver_id")
	private Long receiverId;

	/**
	 * 发放结果状态
	 */
	@ApiField("status")
	private Long status;

	/**
	 * 发放成功数
	 */
	@ApiField("success_quantity")
	private Long successQuantity;

	/**
	 * 总数
	 */
	@ApiField("total_quantity")
	private Long totalQuantity;

	/**
	 * 唯一键
	 */
	@ApiField("unique_id")
	private String uniqueId;


	public String getAlipayAccountNo() {
		return this.alipayAccountNo;
	}
	public void setAlipayAccountNo(String alipayAccountNo) {
		this.alipayAccountNo = alipayAccountNo;
	}

	public Long getBenefitType() {
		return this.benefitType;
	}
	public void setBenefitType(Long benefitType) {
		this.benefitType = benefitType;
	}

	public String getErrorCode() {
		return this.errorCode;
	}
	public void setErrorCode(String errorCode) {
		this.errorCode = errorCode;
	}

	public String getFeature() {
		return this.feature;
	}
	public void setFeature(String feature) {
		this.feature = feature;
	}

	public List<String> getInstanceIds() {
		return this.instanceIds;
	}
	public void setInstanceIds(List<String> instanceIds) {
		this.instanceIds = instanceIds;
	}

	public String getOutObjectId() {
		return this.outObjectId;
	}
	public void setOutObjectId(String outObjectId) {
		this.outObjectId = outObjectId;
	}

	public Long getPurchaserId() {
		return this.purchaserId;
	}
	public void setPurchaserId(Long purchaserId) {
		this.purchaserId = purchaserId;
	}

	public Long getReceiverId() {
		return this.receiverId;
	}
	public void setReceiverId(Long receiverId) {
		this.receiverId = receiverId;
	}

	public Long getStatus() {
		return this.status;
	}
	public void setStatus(Long status) {
		this.status = status;
	}

	public Long getSuccessQuantity() {
		return this.successQuantity;
	}
	public void setSuccessQuantity(Long successQuantity) {
		this.successQuantity = successQuantity;
	}

	public Long getTotalQuantity() {
		return this.totalQuantity;
	}
	public void setTotalQuantity(Long totalQuantity) {
		this.totalQuantity = totalQuantity;
	}

	public String getUniqueId() {
		return this.uniqueId;
	}
	public void setUniqueId(String uniqueId) {
		this.uniqueId = uniqueId;
	}

}
