package com.taobao.api.domain;

import java.util.List;
import com.taobao.api.internal.mapping.ApiField;
import com.taobao.api.internal.mapping.ApiListField;
import com.taobao.api.TaobaoObject;


/**
 * 发放结果
 *
 * @author top auto create
 * @since 1.0, null
 */
public class SingleBenefitSendResult extends TaobaoObject {

	private static final long serialVersionUID = 2431531127831232418L;

	/**
	 * 错误码
	 */
	@ApiField("error_code")
	private String errorCode;

	/**
	 * 错误信息
	 */
	@ApiField("error_message")
	private String errorMessage;

	/**
	 * 用于宝箱应用，为true表示宝箱任务已完成，需要提示用户
	 */
	@ApiField("is_baoxiang_task_done")
	private Boolean isBaoxiangTaskDone;

	/**
	 * 是否发放成功
	 */
	@ApiField("is_success")
	private Boolean isSuccess;

	/**
	 * 单次发放结果
	 */
	@ApiListField("results")
	@ApiField("mobile_benefit_send_result_ext")
	private List<MobileBenefitSendResultExt> results;

	/**
	 * 事务id
	 */
	@ApiField("unique_id")
	private String uniqueId;


	public String getErrorCode() {
		return this.errorCode;
	}
	public void setErrorCode(String errorCode) {
		this.errorCode = errorCode;
	}

	public String getErrorMessage() {
		return this.errorMessage;
	}
	public void setErrorMessage(String errorMessage) {
		this.errorMessage = errorMessage;
	}

	public Boolean getIsBaoxiangTaskDone() {
		return this.isBaoxiangTaskDone;
	}
	public void setIsBaoxiangTaskDone(Boolean isBaoxiangTaskDone) {
		this.isBaoxiangTaskDone = isBaoxiangTaskDone;
	}

	public Boolean getIsSuccess() {
		return this.isSuccess;
	}
	public void setIsSuccess(Boolean isSuccess) {
		this.isSuccess = isSuccess;
	}

	public List<MobileBenefitSendResultExt> getResults() {
		return this.results;
	}
	public void setResults(List<MobileBenefitSendResultExt> results) {
		this.results = results;
	}

	public String getUniqueId() {
		return this.uniqueId;
	}
	public void setUniqueId(String uniqueId) {
		this.uniqueId = uniqueId;
	}

}
