package com.taobao.api.request;

import java.util.List;
import com.taobao.api.internal.mapping.ApiField;
import com.taobao.api.internal.mapping.ApiListField;
import com.taobao.api.TaobaoObject;
import java.util.Map;

import com.taobao.api.ApiRuleException;
import com.taobao.api.BaseTaobaoRequest;
import com.taobao.api.internal.util.TaobaoHashMap;
import com.taobao.api.internal.util.json.JSONWriter;
import com.taobao.api.response.AlibabaArgusAddredriskResponse;

/**
 * TOP API: alibaba.argus.addredrisk request
 * 
 * @author top auto create
 * @since 1.0, 2022.04.28
 */
public class AlibabaArgusAddredriskRequest extends BaseTaobaoRequest<AlibabaArgusAddredriskResponse> {
	
	

	/** 
	* 红线价格设置参数
	 */
	private String redRiskFactor;

	public void setRedRiskFactor(String redRiskFactor) {
		this.redRiskFactor = redRiskFactor;
	}

	public void setRedRiskFactor(RedRiskFactor redRiskFactor) {
		this.redRiskFactor = new JSONWriter(false,true).write(redRiskFactor);
	}

	public String getRedRiskFactor() {
		return this.redRiskFactor;
	}

	public String getApiMethodName() {
		return "alibaba.argus.addredrisk";
	}

	public Map<String, String> getTextParams() {		
		TaobaoHashMap txtParams = new TaobaoHashMap();
		txtParams.put("red_risk_factor", this.redRiskFactor);
		if(this.udfParams != null) {
			txtParams.putAll(this.udfParams);
		}
		return txtParams;
	}

	public Class<AlibabaArgusAddredriskResponse> getResponseClass() {
		return AlibabaArgusAddredriskResponse.class;
	}

	public void check() throws ApiRuleException {
	}
	
	/**
 * sku红线价格
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class SkuRedRiskFactor extends TaobaoObject {

	private static final long serialVersionUID = 5347955597923324493L;

	/**
		 * sku红线价格
		 */
		@ApiField("amount_at")
		private Long amountAt;
		/**
		 * skuId
		 */
		@ApiField("sku_id")
		private Long skuId;
	

	public Long getAmountAt() {
			return this.amountAt;
		}
		public void setAmountAt(Long amountAt) {
			this.amountAt = amountAt;
		}
		public Long getSkuId() {
			return this.skuId;
		}
		public void setSkuId(Long skuId) {
			this.skuId = skuId;
		}

}

	/**
 * 风险等级设置
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class RiskLevelParam extends TaobaoObject {

	private static final long serialVersionUID = 7548418775834915842L;

	/**
		 * 风险等级(可选值:higher-risk,middle-risk,low-risk)
		 */
		@ApiField("key")
		private String key;
		/**
		 * 风险等级比例左边值（-1代表到无穷小）
		 */
		@ApiField("left_range")
		private Long leftRange;
		/**
		 * 风险等级比例右边值（-1代表到无穷大）
		 */
		@ApiField("right_range")
		private Long rightRange;
	

	public String getKey() {
			return this.key;
		}
		public void setKey(String key) {
			this.key = key;
		}
		public Long getLeftRange() {
			return this.leftRange;
		}
		public void setLeftRange(Long leftRange) {
			this.leftRange = leftRange;
		}
		public Long getRightRange() {
			return this.rightRange;
		}
		public void setRightRange(Long rightRange) {
			this.rightRange = rightRange;
		}

}

	/**
 * 红线价格设置参数
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class RedRiskFactor extends TaobaoObject {

	private static final long serialVersionUID = 1661257969163977943L;

	/**
		 * 商品红线价格
		 */
		@ApiField("amount_at")
		private Long amountAt;
		/**
		 * 商品id
		 */
		@ApiField("item_id")
		private Long itemId;
		/**
		 * 风险等级设置
		 */
		@ApiListField("risk_levels")
		@ApiField("risk_level_param")
		private List<RiskLevelParam> riskLevels;
		/**
		 * sku红线价格
		 */
		@ApiListField("sku_risk_factors")
		@ApiField("sku_red_risk_factor")
		private List<SkuRedRiskFactor> skuRiskFactors;
	

	public Long getAmountAt() {
			return this.amountAt;
		}
		public void setAmountAt(Long amountAt) {
			this.amountAt = amountAt;
		}
		public Long getItemId() {
			return this.itemId;
		}
		public void setItemId(Long itemId) {
			this.itemId = itemId;
		}
		public List<RiskLevelParam> getRiskLevels() {
			return this.riskLevels;
		}
		public void setRiskLevels(List<RiskLevelParam> riskLevels) {
			this.riskLevels = riskLevels;
		}
		public List<SkuRedRiskFactor> getSkuRiskFactors() {
			return this.skuRiskFactors;
		}
		public void setSkuRiskFactors(List<SkuRedRiskFactor> skuRiskFactors) {
			this.skuRiskFactors = skuRiskFactors;
		}

}


}