package com.taobao.api.request;

import com.taobao.api.internal.util.RequestCheckUtils;
import java.util.Map;

import com.taobao.api.ApiRuleException;
import com.taobao.api.BaseTaobaoRequest;
import com.taobao.api.internal.util.TaobaoHashMap;

import com.taobao.api.response.AlibabaBenefitDrawResponse;

/**
 * TOP API: alibaba.benefit.draw request
 * 
 * @author top auto create
 * @since 1.0, 2020.10.14
 */
public class AlibabaBenefitDrawRequest extends BaseTaobaoRequest<AlibabaBenefitDrawResponse> {
	
	

	/** 
	* 调用方AppName：规定为promotioncenter-${appId}
	 */
	private String appName;

	/** 
	* 奖池唯一标识，奖池创建时即生成
	 */
	private String ename;

	/** 
	* 调用方应用ip，非必填
	 */
	private String ip;

	public void setAppName(String appName) {
		this.appName = appName;
	}

	public String getAppName() {
		return this.appName;
	}

	public void setEname(String ename) {
		this.ename = ename;
	}

	public String getEname() {
		return this.ename;
	}

	public void setIp(String ip) {
		this.ip = ip;
	}

	public String getIp() {
		return this.ip;
	}

	public String getApiMethodName() {
		return "alibaba.benefit.draw";
	}

	public Map<String, String> getTextParams() {		
		TaobaoHashMap txtParams = new TaobaoHashMap();
		txtParams.put("app_name", this.appName);
		txtParams.put("ename", this.ename);
		txtParams.put("ip", this.ip);
		if(this.udfParams != null) {
			txtParams.putAll(this.udfParams);
		}
		return txtParams;
	}

	public Class<AlibabaBenefitDrawResponse> getResponseClass() {
		return AlibabaBenefitDrawResponse.class;
	}

	public void check() throws ApiRuleException {
		RequestCheckUtils.checkNotEmpty(appName, "appName");
		RequestCheckUtils.checkNotEmpty(ename, "ename");
	}
	

}