package com.taobao.api.request;

import com.taobao.api.internal.mapping.ApiField;
import com.taobao.api.TaobaoObject;
import java.util.Date;
import java.util.Map;

import com.taobao.api.ApiRuleException;
import com.taobao.api.BaseTaobaoRequest;
import com.taobao.api.internal.util.TaobaoHashMap;
import com.taobao.api.internal.util.json.JSONWriter;
import com.taobao.api.response.AlibabaBenefitInstanceWriteoffResponse;

/**
 * TOP API: alibaba.benefit.instance.writeoff request
 * 
 * @author top auto create
 * @since 1.0, 2022.04.28
 */
public class AlibabaBenefitInstanceWriteoffRequest extends BaseTaobaoRequest<AlibabaBenefitInstanceWriteoffResponse> {
	
	

	/** 
	* 入参
	 */
	private String param0;

	public void setParam0(String param0) {
		this.param0 = param0;
	}

	public void setParam0(BenefitInstanceDealRequest param0) {
		this.param0 = new JSONWriter(false,true).write(param0);
	}

	public String getParam0() {
		return this.param0;
	}

	public String getApiMethodName() {
		return "alibaba.benefit.instance.writeoff";
	}

	public Map<String, String> getTextParams() {		
		TaobaoHashMap txtParams = new TaobaoHashMap();
		txtParams.put("param0", this.param0);
		if(this.udfParams != null) {
			txtParams.putAll(this.udfParams);
		}
		return txtParams;
	}

	public Class<AlibabaBenefitInstanceWriteoffResponse> getResponseClass() {
		return AlibabaBenefitInstanceWriteoffResponse.class;
	}

	public void check() throws ApiRuleException {
	}
	
	/**
 * 入参
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class BenefitInstanceDealRequest extends TaobaoObject {

	private static final long serialVersionUID = 5545519836223579561L;

	/**
		 * json格式，详询开发
		 */
		@ApiField("deal_action")
		private String dealAction;
		/**
		 * 履约时间
		 */
		@ApiField("deal_time")
		private Date dealTime;
		/**
		 * 权益资产实例 id
		 */
		@ApiField("instance_id")
		private Long instanceId;
		/**
		 * 淘系混淆 uid
		 */
		@ApiField("mix_uid")
		private String mixUid;
		/**
		 * 外部订单 id
		 */
		@ApiField("out_order_id")
		private String outOrderId;
		/**
		 * 履约地点
		 */
		@ApiField("region")
		private String region;
	

	public String getDealAction() {
			return this.dealAction;
		}
		public void setDealAction(String dealAction) {
			this.dealAction = dealAction;
		}
		public Date getDealTime() {
			return this.dealTime;
		}
		public void setDealTime(Date dealTime) {
			this.dealTime = dealTime;
		}
		public Long getInstanceId() {
			return this.instanceId;
		}
		public void setInstanceId(Long instanceId) {
			this.instanceId = instanceId;
		}
		public String getMixUid() {
			return this.mixUid;
		}
		public void setMixUid(String mixUid) {
			this.mixUid = mixUid;
		}
		public String getOutOrderId() {
			return this.outOrderId;
		}
		public void setOutOrderId(String outOrderId) {
			this.outOrderId = outOrderId;
		}
		public String getRegion() {
			return this.region;
		}
		public void setRegion(String region) {
			this.region = region;
		}

}


}