package com.taobao.api.request;

import java.util.Map;

import com.taobao.api.ApiRuleException;
import com.taobao.api.BaseTaobaoRequest;
import com.taobao.api.internal.util.TaobaoHashMap;

import com.taobao.api.response.AlibabaCbuUserHtTestResponse;

/**
 * TOP API: alibaba.cbu.user.ht.test request
 * 
 * @author top auto create
 * @since 1.0, 2020.11.26
 */
public class AlibabaCbuUserHtTestRequest extends BaseTaobaoRequest<AlibabaCbuUserHtTestResponse> {
	
	

	/** 
	* 地址信息
	 */
	private String address;

	public void setAddress(String address) {
		this.address = address;
	}

	public String getAddress() {
		return this.address;
	}

	public String getApiMethodName() {
		return "alibaba.cbu.user.ht.test";
	}

	public Map<String, String> getTextParams() {		
		TaobaoHashMap txtParams = new TaobaoHashMap();
		txtParams.put("address", this.address);
		if(this.udfParams != null) {
			txtParams.putAll(this.udfParams);
		}
		return txtParams;
	}

	public Class<AlibabaCbuUserHtTestResponse> getResponseClass() {
		return AlibabaCbuUserHtTestResponse.class;
	}

	public void check() throws ApiRuleException {
	}
	

}