package com.taobao.api.request;

import java.util.List;
import com.taobao.api.internal.mapping.ApiField;
import com.taobao.api.internal.mapping.ApiListField;
import com.taobao.api.TaobaoObject;
import java.util.Date;
import java.util.Map;

import com.taobao.api.ApiRuleException;
import com.taobao.api.BaseTaobaoRequest;
import com.taobao.api.internal.util.TaobaoHashMap;
import com.taobao.api.internal.util.json.JSONWriter;
import com.taobao.api.response.AlibabaLafiteSellerActivityListResponse;

/**
 * TOP API: alibaba.lafite.seller.activity.list request
 * 
 * @author top auto create
 * @since 1.0, 2022.04.28
 */
public class AlibabaLafiteSellerActivityListRequest extends BaseTaobaoRequest<AlibabaLafiteSellerActivityListResponse> {
	
	

	/** 
	* 请求入参
	 */
	private String query;

	public void setQuery(String query) {
		this.query = query;
	}

	public void setQuery(ActivityReadTopQuery query) {
		this.query = new JSONWriter(false,true).write(query);
	}

	public String getQuery() {
		return this.query;
	}

	public String getApiMethodName() {
		return "alibaba.lafite.seller.activity.list";
	}

	public Map<String, String> getTextParams() {		
		TaobaoHashMap txtParams = new TaobaoHashMap();
		txtParams.put("query", this.query);
		if(this.udfParams != null) {
			txtParams.putAll(this.udfParams);
		}
		return txtParams;
	}

	public Class<AlibabaLafiteSellerActivityListResponse> getResponseClass() {
		return AlibabaLafiteSellerActivityListResponse.class;
	}

	public void check() throws ApiRuleException {
	}
	
	/**
 * 请求入参
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class ActivityReadTopQuery extends TaobaoObject {

	private static final long serialVersionUID = 7232651437452511776L;

	/**
		 * 当前页
		 */
		@ApiField("current_page")
		private Long currentPage;
		/**
		 * 发放结束时间左值
		 */
		@ApiField("end_time_begin")
		private Date endTimeBegin;
		/**
		 * 发放结束时间右值
		 */
		@ApiField("end_time_end")
		private Date endTimeEnd;
		/**
		 * 每页记录数
		 */
		@ApiField("page_size")
		private Long pageSize;
		/**
		 * 业务来源
		 */
		@ApiField("source")
		private String source;
		/**
		 * 发放开始时间左值
		 */
		@ApiField("start_time_begin")
		private Date startTimeBegin;
		/**
		 * 发放开始时间右值
		 */
		@ApiField("start_time_end")
		private Date startTimeEnd;
		/**
		 * 筛选状态列表，EFFECTIVE为生效，OFFLINE为下线
		 */
		@ApiListField("status_list")
		@ApiField("string")
		private List<String> statusList;
	

	public Long getCurrentPage() {
			return this.currentPage;
		}
		public void setCurrentPage(Long currentPage) {
			this.currentPage = currentPage;
		}
		public Date getEndTimeBegin() {
			return this.endTimeBegin;
		}
		public void setEndTimeBegin(Date endTimeBegin) {
			this.endTimeBegin = endTimeBegin;
		}
		public Date getEndTimeEnd() {
			return this.endTimeEnd;
		}
		public void setEndTimeEnd(Date endTimeEnd) {
			this.endTimeEnd = endTimeEnd;
		}
		public Long getPageSize() {
			return this.pageSize;
		}
		public void setPageSize(Long pageSize) {
			this.pageSize = pageSize;
		}
		public String getSource() {
			return this.source;
		}
		public void setSource(String source) {
			this.source = source;
		}
		public Date getStartTimeBegin() {
			return this.startTimeBegin;
		}
		public void setStartTimeBegin(Date startTimeBegin) {
			this.startTimeBegin = startTimeBegin;
		}
		public Date getStartTimeEnd() {
			return this.startTimeEnd;
		}
		public void setStartTimeEnd(Date startTimeEnd) {
			this.startTimeEnd = startTimeEnd;
		}
		public List<String> getStatusList() {
			return this.statusList;
		}
		public void setStatusList(List<String> statusList) {
			this.statusList = statusList;
		}

}


}