package com.taobao.api.request;

import java.util.List;
import com.taobao.api.internal.mapping.ApiField;
import com.taobao.api.internal.mapping.ApiListField;
import com.taobao.api.TaobaoObject;
import java.util.Date;
import java.util.Map;

import com.taobao.api.ApiRuleException;
import com.taobao.api.BaseTaobaoRequest;
import com.taobao.api.internal.util.TaobaoHashMap;
import com.taobao.api.internal.util.json.JSONWriter;
import com.taobao.api.response.AlibabaLafiteSellerBenefitListResponse;

/**
 * TOP API: alibaba.lafite.seller.benefit.list request
 * 
 * @author top auto create
 * @since 1.0, 2022.12.14
 */
public class AlibabaLafiteSellerBenefitListRequest extends BaseTaobaoRequest<AlibabaLafiteSellerBenefitListResponse> {
	
	

	/** 
	* 查询参数
	 */
	private String benefitReadTopQuery;

	public void setBenefitReadTopQuery(String benefitReadTopQuery) {
		this.benefitReadTopQuery = benefitReadTopQuery;
	}

	public void setBenefitReadTopQuery(BenefitReadTopQuery benefitReadTopQuery) {
		this.benefitReadTopQuery = new JSONWriter(false,true).write(benefitReadTopQuery);
	}

	public String getBenefitReadTopQuery() {
		return this.benefitReadTopQuery;
	}

	public String getApiMethodName() {
		return "alibaba.lafite.seller.benefit.list";
	}

	public Map<String, String> getTextParams() {		
		TaobaoHashMap txtParams = new TaobaoHashMap();
		txtParams.put("benefit_read_top_query", this.benefitReadTopQuery);
		if(this.udfParams != null) {
			txtParams.putAll(this.udfParams);
		}
		return txtParams;
	}

	public Class<AlibabaLafiteSellerBenefitListResponse> getResponseClass() {
		return AlibabaLafiteSellerBenefitListResponse.class;
	}

	public void check() throws ApiRuleException {
	}
	
	/**
 * 查询参数
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class BenefitReadTopQuery extends TaobaoObject {

	private static final long serialVersionUID = 7283289628828523473L;

	/**
		 * 权益code
		 */
		@ApiListField("benefit_codes")
		@ApiField("string")
		private List<String> benefitCodes;
		/**
		 * 权益类型
		 */
		@ApiField("benefit_type")
		private String benefitType;
		/**
		 * 当前页
		 */
		@ApiField("current_page")
		private Long currentPage;
		/**
		 * 权益发放结束时间大于该值
		 */
		@ApiField("end_time_begin")
		private Date endTimeBegin;
		/**
		 * 权益发放结束时间小于该值
		 */
		@ApiField("end_time_end")
		private Date endTimeEnd;
		/**
		 * 每页记录数
		 */
		@ApiField("page_size")
		private Long pageSize;
		/**
		 * 业务来源
		 */
		@ApiField("source")
		private String source;
		/**
		 * 权益发放开始时间大于该值
		 */
		@ApiField("start_time_begin")
		private Date startTimeBegin;
		/**
		 * 权益发放开始时间小于该值
		 */
		@ApiField("start_time_end")
		private Date startTimeEnd;
		/**
		 * 状态,online,offline,invalid
		 */
		@ApiListField("statuses")
		@ApiField("string")
		private List<String> statuses;
	

	public List<String> getBenefitCodes() {
			return this.benefitCodes;
		}
		public void setBenefitCodes(List<String> benefitCodes) {
			this.benefitCodes = benefitCodes;
		}
		public String getBenefitType() {
			return this.benefitType;
		}
		public void setBenefitType(String benefitType) {
			this.benefitType = benefitType;
		}
		public Long getCurrentPage() {
			return this.currentPage;
		}
		public void setCurrentPage(Long currentPage) {
			this.currentPage = currentPage;
		}
		public Date getEndTimeBegin() {
			return this.endTimeBegin;
		}
		public void setEndTimeBegin(Date endTimeBegin) {
			this.endTimeBegin = endTimeBegin;
		}
		public Date getEndTimeEnd() {
			return this.endTimeEnd;
		}
		public void setEndTimeEnd(Date endTimeEnd) {
			this.endTimeEnd = endTimeEnd;
		}
		public Long getPageSize() {
			return this.pageSize;
		}
		public void setPageSize(Long pageSize) {
			this.pageSize = pageSize;
		}
		public String getSource() {
			return this.source;
		}
		public void setSource(String source) {
			this.source = source;
		}
		public Date getStartTimeBegin() {
			return this.startTimeBegin;
		}
		public void setStartTimeBegin(Date startTimeBegin) {
			this.startTimeBegin = startTimeBegin;
		}
		public Date getStartTimeEnd() {
			return this.startTimeEnd;
		}
		public void setStartTimeEnd(Date startTimeEnd) {
			this.startTimeEnd = startTimeEnd;
		}
		public List<String> getStatuses() {
			return this.statuses;
		}
		public void setStatuses(List<String> statuses) {
			this.statuses = statuses;
		}

}


}